/*
    Copyright 2015 Adobe Systems Incorporated.  All rights reserved. 
*/

/*global require, module, console */
/*jslint nomen: true*/

var socketFactory = require('./socketFactory.js');

function ScrollCommand(socket, data) {
    "use strict";
    this.io = socketFactory.io;
    this.socket = socket;
    this.data = data;
}

ScrollCommand.prototype.execute = function () {
    "use strict";
    if (this.socket.authorized === true) {
        var socketGroup = this.socket.request.group;
        if (socketGroup !== '') {
            this.socket.broadcast.to(socketGroup).emit('scroll', this.data);
        }
    }
};

module.exports = ScrollCommand;